function plot_speech_frame(curr_file,ss,L,graphicPanel,iwindow,fs);
%
% function to plot current speech frame using designated window

% Inputs:
%   curr_file: current speech file
%   ss: starting sample in speech file for display of frame
%   L: duration of speech frame
%   graphicPanel: graphic panel in which speech frame plot to be shown
%   iwindow: window type, 1:Hamming, 2:rectangular
%   fs: speech sampling rate (samples/second)

% create frame of speech, weight using window
    if (iwindow == 1)
        x1=curr_file(ss:ss+L-1).*hamming(L);
    else
        x1=curr_file(ss:ss+L-1);
    end
    
% plot frame of speech using Hamming window in graphicPanel
    reset(graphicPanel);
    axes(graphicPanel);
    cla;
    plot(0:L-1,x1,'k','LineWidth',2);
    xpp=['time in samples; fs=',num2str(fs),' samples/second'];
    xlabel(xpp);ylabel('amplitude'); 
    grid on;axis tight;
end